//Dustin Soodak

#ifndef MISC_HARDWARE_H
#define MISC_HARDWARE_H

#include <Adafruit_NeoPixel.h>
#include "Pitches.h"


// ***************************************************
// Pin defines
// ***************************************************

//
#define Accel_Interrupt 2 //used by both Gyro and Accel chips.
#define Accel_Interrupt_Num 0 //pin2 is interrupt 0 on arduino uno board
#define MotorDirection_Right 1
#define MotorDirection_Left 0
#define MotorDrive_Left 6
#define MotorDrive_Right 5
//
#define Chirp 9 //tone(pin, frequency) and noTone(),  or tone(pin, frequency, duration). also look at toneAC library
#define Edge_Lights 8 //turn on IR_FRNT_LEFT_BTM and IR_FRNT_RGHT_BTM
#define _38kHz_Rx 3
#define LightSense_Rear 3 //AD3
#define Source_Select 4 
#define LightSense_Left 2 //AD2 //Source_Select LOW=AMB_FRNT_LEFT, HIGH=EDGE_FRNT_LEFT
#define LightSense_Right 1 //AD1 //Source_Select LOW=AMB_FRNT_RIGHT, HIGH=EDGE_FRNT_RIGHT
#define MotorCapBattVolts 0 //AD0 //Source_Select LOW=motor capacitor, HIGH=battery
//
#define IR_Enable_Front 13
#define IR_Enable_RearLeft 12
#define IR_Enable_RearRight 11
#define IR_Send 10
//
#define Light_Bus_BTN1 7 //for 6 neo pixel RGB

// ***************************************************
// end Pin defines
// ***************************************************

// ***************************************************
// General hardware
// ***************************************************
#define SERIAL_SPEED 57600
extern void HardwareBegin(void);
extern void SwitchButtonToPixels(void);
extern void SwitchPixelsToButton(void);
extern void SwitchSerialToMotors(void);
extern void SwitchMotorsToSerial(void);
extern char ButtonPressed(void);
//Note: "while(!Serial.available());  delus=Serial.parseInt();" to wait for numerical input from user
// ***************************************************
// end General hardware
// ***************************************************

// ***************************************************
// Simple Timer
// ***************************************************
  //Ultra-simple stop watch functions using the built-in arduino millis() function.
  extern int32_t GetTime(void);
  extern void RestartTimer(void);
  extern void StopTimer(void);
// ***************************************************
// end Simple Timer
// ***************************************************


// ***************************************************
// Pixels
// ***************************************************
#define NUM_PIXELS 6
extern void SetPixelRGB(int Pixel, int Red, int Green, int Blue);
extern void SetAllPixelsRGB(int Red, int Green, int Blue);//0-255
extern void RefreshPixels(void);
//Ex: SetButtonToPixels();SetPixelRGB(1,100,100,100);RefreshPixels();
//will turn pixel 1 white at a bit less than half brightness 
//1 is back, 2 and 3 are bottom "mood lighting", and 4 is top.
//5 is right headlight/eye, and 6 is left headlight/eye
//
//low level/misc:
//
extern Adafruit_NeoPixel pixels;// = Adafruit_NeoPixel(NUM_PIXELS, Light_Bus_BTN1, NEO_GRB + NEO_KHZ800);
#define H_Bright 50 //headlight brightness used in some examples
#define M_Bright 50 //moodlighting brightness used in some examples
// ***************************************************
// end Pixels
// ***************************************************


// ***************************************************
// Chirp
// ***************************************************
extern void PlayChirp(unsigned int Frequency, unsigned int Amplitude);//Amplitude: 0-50 (50 gives max voltage of 17: hardware to be tuned better later)
extern void PlayAnger(void);
extern void PlayBoredom(void);
extern void PlayExcited(void);
//  PlayChirp(NOTE_G5,30);
//  delay(200);
//  PlayChirp(NOTE_C6,40);
// ***************************************************
// end Chirp
// ***************************************************

// ***************************************************
// Motor
// ***************************************************
#define MOTOR_MAX 255 //motor goes from -255 to 255
extern int LeftMotor;//current motor speed
extern int RightMotor;//current motor speed
extern void MotorsBegin(void);
extern void Motors(int LeftMotorSpeed, int RightMotorSpeed);//-255 to 255: negative values to make it go backwards
// ***************************************************
// end Motor
// ***************************************************


// ***************************************************
// Movement functions
// ***************************************************
//Note: most of these call "ZeroNavigationSensors()" in beginning. Navigation
//will be innacurate if robot is moving at this point.
//
//if 0 entered for EdgeFunction, the move functions will not look for edges.
//If something like Backup with definition void BackUp(void){Motors(-200,-200);}
//is entered, then it will be called when an edge is detected.
//
extern void MoveWithOptions(int Direction, int Speed, int Distance, int MaxExpectedRunTime, int MaxExpectedSkidTime, 
                                    void (*EdgeFunction)(char), char Wiggle);//50 is about medium wiggle
//  ex: MoveWithOptions(45, 150, 200, 3000, 500, 0,0);
//    maintain 45 degree heading at motor speed 150 for 200mm. Timeout at 3000ms and wait up to 500ms for it to skid to a halt. Don't react to edges and don't wiggle.                        
//  Note: This uses the SimpleNavigation function which only keeps track of the y-axis.
//    Therefore, total distance will not be accurate if non-zero wiggle since the accelerometer is in the front of
//    the robot and thus spinning will make it think it is going backwards.
//
extern void MoveXYWithOptions(int X, int Y, int Speed, int MaxExpectedRunTime, int MaxExpectedSkidTime, void (*EdgeFunction)(char), char Wiggle);
//  Same as MoveWithOptions() but it goes towards destination {X,Y}.
//    However, this function calculates with both x and y acceleration so is not
//    affected by the Wiggle parameter.
//  ex: ZeroNavigation();MoveXYWithOptions(0,200,150,3000,500,0,50);
//    Since navigation zeroed, it is at coordinates {0,0} and facing 0 degrees (Pi/2 radians) along y-axis.
//    It will wiggle back and forth but still should stop after its y-coordinate reaches
//    approximately 200mm. 
//  In general, this function draws a finish line that is perpendicular to
//    the route from the initial to final {x,y} position. It then continuously
//    resets the "heading" parameter so that it is facing towards the final position
//    and stops when the original finish line is crossed.
//
extern void RotateSimple(int TurnDegrees, int left, int right, int MaxExpectedTurnTime, int MaxExpectedSkidTime);
//  ex: RotateSimple(GetDegrees()+90, 150, 0, 1000, 250);//approximate rotation
//    Set left motor to 150 and right motor to 0. Stop both motors when the 
//    heading we expect to be at after skidding to a halt is 90 degrees to the
//    right of its initial heading.
//  Note: this uses GetDegreesToStop() which looks at how fast it is currently
//    rotating (GetDegreesPerSecond()) and estimates how much further it will
//    go if motors are turned off right now.
//  
extern char RotateAccurate(int Heading, int MaxExpectedTurnTime);
//  ex: RotateAccurate(45,1000);
//    exact rotation (45 degrees to right if ZeroNavigation() just called) with timeout of 1000ms
//

// ***************************************************
// end Movement functions
// ***************************************************


// ***************************************************
// random examples and obsolete movement functions
// ***************************************************

//extern void MoveStraight(int Speed, int ms, int MaxExpectedSkidTime);
extern void MoveStraight(int Direction, int Speed, int Distance, int MaxExpectedRunTime, int MaxExpectedSkidTime);//Distance=0 to just go for MaxExpectedRunTime
extern void MoveStraightWithFullOptions(int Direction, int Speed, int Distance, int MaxExpectedRunTime, int MaxExpectedSkidTime, void (*EdgeFunction)(char), 
                                    int PIDRange, float ProportionalTerm, float IntegralTerm, float DerivativeTerm);

extern void BrightnessNavigationExample(int Speed, unsigned int MaxExpectedRunTimeSec, char FindLight);
//BrightnessNavigationExample(150, 60,0); goes at speed 150 for 60 seconds and goes towards the dark.

extern void ExploreExample(int Speed, unsigned int MaxExpectedRunTimeSec, int MaxExpectedSkidTimeMs);
extern void MaintainPositionExample(void);
// ***************************************************
// random examples and obsolete movement functions
// ***************************************************



// ***************************************************
// IR
// ***************************************************
extern void TxIR(char *Data, int Length);
//
extern void RxIRStop(void);
extern void RxIRRestart(void);
extern char IsIRDone(void);
extern char IRNumOfBytes;
//
int WaitForIRButton(void);
//Note: first and second bytes are always 0x00 and 0xFF. IRRemoteButtons[] contains the third and fourth bytes.
//code generated in IR tab of Ringo spreadsheet
extern const uint8_t IRRemoteButtons[][2];//={{0x16,0xE9},{0x0C,0xF3},{0x18,0xE7},{0x5E,0xA1},{0x08,0xF7},{0x1C,0xE3},{0x5A,0xA5},{0x42,0xBD},{0x52,0xAD},{0x4A,0xB5},{0x15,0xEA},{0x40,0xBF},{0x19,0xE6},{0x09,0xF6},{0x07,0xF8},{0x43,0xBC},{0x44,0xBB},{0x47,0xB8},{0x45,0xBA}};
#define IR_0 0
#define IR_1 1
#define IR_2 2
#define IR_3 3
#define IR_4 4
#define IR_5 5
#define IR_6 6
#define IR_7 7
#define IR_8 8
#define IR_9 9
#define IR_Play 10
#define IR_Plus 11
#define IR_Minus 12
#define IR_FastForward 13
#define IR_Rewind 14
#define IR_Back 15
#define IR_Test 16
#define IR_Menu 17
#define IR_Power 18
//

//
extern void IRMenuTest(void);
//
//Low level:
//
extern int IRTransitionCount;
extern unsigned char IRBytes[20];
extern char IRActive;
extern volatile char IRReceiving;//note: IRReceiving turned off if IsIRDone() in regular or auto NavigationHandler() and causes ReadSideSensors() to repeat
//
extern void PlayChirpIR(unsigned int Frequency, unsigned int DutyCycle);//PlayChirpIR(38000,6) seems to produce best square wave.
extern void ModulateIR(char Level);
//
extern void IRHandler(void);
//
// ***************************************************
// end IR
// ***************************************************

// ***************************************************
// Light & Edge Sensing
// ***************************************************
//
extern void ReadSideSensors(void);//single relative & ambient reading from each of the 3 side sensors (pauses and/or repeats if IRReceiving)
extern int RightLightLevel,LeftLightLevel,RearLightLevel;
extern int RearAmbientLightLevel,RightAmbientLightLevel,LeftAmbientLightLevel;
//
extern void ReadEdgeLightSensors(char Averages);//averages 8 reads
extern int RightEdgeLightLevel,LeftEdgeLightLevel;
//
extern void ResetLookAtEdge(void);//reset edge runnning average
extern void LookAtEdge(void);//take readings and add to running average (first call ResetLookAtEdge() once)
extern int LeftEdgeSensorAverage,RightEdgeSensorAverage;
extern int LeftEdgeSensorValue,RightEdgeSensorValue;
//
extern char LookForEdge(void);
// calls LookAtEdge(), and uses running average to detect edges or white tape.
// Output bits: 0: right edge, 1: left edge, 2: right tape, 3: left tape
// Must call ResetLookAtEdge() once, then put LookForEdge() in loop with the rest of
//  your movement function. 
// Will not get stuck on, but this means that if hovering over an edge or tape, it 
//  eventually "gets used' to it and trigger will go off.
// If not at least few milliseconds pause between calls, LookForEdge() might be less likely 
//  to detect an edge.
//Example for waiting till off of edge (or tape):
// If a left edge was encountered, you could store the current value of
//  LeftEdgeSensorAverage, then keep calling LookForEdge() (or just LookAtEdge()) until
//  LeftEdgeSensorValue is greater than the stored average value.
//
//Low level:
//
//For LookAtEdge()
extern int LeftEdgeArray[8];
extern int RightEdgeArray[8];
extern char EdgeArrayPos;
//
extern void EdgeLightsOn(void);
extern void EdgeLightsOff(void);
//
extern void SwitchAmbientToEdge(void);
extern void SwitchEdgeToAmbient(void);
//
extern int ReadLeftLightSensor(void);
extern int ReadRightLightSensor(void);
extern int ReadBackLightSensor(void);
//
//
// ***************************************************
// end Light & Edge Sensing
// ***************************************************



















//

// ***************************************************
// end Misc Hardware
// ***************************************************







/*ReadSideSensors

 
  //clear pixels and blink the first one blue
  SwitchButtonToPixels();  
  SetAllPixelsRGB(0,0,0);
  SetPixelRGB(0,0,0,255);
  RefreshPixels();
  delay(100);
  SetPixelRGB(0,0,0,0);
  RefreshPixels();
  //read light levels till button pressed
  EdgeLightsOn();
  SwitchAmbientToEdge();
  SwitchMotorsToSerial();
  SwitchPixelsToButton();
  while(!ButtonPressed()){
    delay(100);
    Serial.print("left: ");
    Serial.print(ReadLeftLightSensor(),DEC);
    Serial.print(" right: ");
    Serial.println(ReadRightLightSensor(),DEC);
  } 
  EdgeLightsOff();
  //wait till button released then wait 1 second
  delay(10);
  while(ButtonPressed()); 
  delay(1000);
  //init and pause navigation
  NavigationBegin();
  PauseNavigation();
  //move as commanded
  RotateSimple(180, 100, -100, 1000, 500);//rotate 180 degrees to the right at speed 100, for max of 1000ms and keep updating position for 500ms more.
  MoveStraight(200, 600, 5000, 500);//move at speed 200 for 600mm(about 2 ft), for max of 5000ms and keep updating position for 500ms more.
    
  
*/





#endif
